import java.awt.geom.Line2D;
import java.util.LinkedList;
import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

public class Gui extends JApplet 
{
    public void init() {
        MapDisplay mapDisplay = new MapDisplay();
        getContentPane().add( mapDisplay, BorderLayout.CENTER );
    }

    public static void main( String[] args ) {
        JFrame frame = new JFrame("Router");
        frame.addWindowListener( new WindowAdapter() {
            public void windowClosing( WindowEvent e ) {
                System.exit(0);
            }
        } );

        System.out.println( args.length );

        MapDisplay mapDisplay = null;
        switch( args.length ){
            case( 0 ) :  mapDisplay = new MapDisplay(); break;
            case( 1 ) :  mapDisplay = new MapDisplay(   args[0] ); break;
            case( 2 ) :  mapDisplay = new MapDisplay(   Integer.valueOf( args[0] ).intValue(), 
                                                        Integer.valueOf( args[1] ).intValue() );
                         break;
            case( 3 ) :  mapDisplay = new MapDisplay(   Integer.valueOf( args[0] ).intValue(), 
                                                        Integer.valueOf( args[1] ).intValue(),
                                                        Integer.valueOf( args[2] ).intValue() );
                         break;
        }
        frame.setSize( new Dimension( 500, 500 ) );
        frame.getContentPane().add( mapDisplay, BorderLayout.CENTER );
        frame.pack();
        frame.setVisible( true );
    }
}

class MapDisplay extends JPanel implements MouseListener
{
    int w;
    int h;
    Router router;
    LinkedList userRoute = new LinkedList();

    int[] x = new int[3];
    int[] y = new int[3];
    
    public MapDisplay()
    {
        w = h = 128;
        init();
        router.genRandomRadar( 20 );
    }

    public MapDisplay( String filename ){
        init();
        router.loadFromFile( filename );
        w = router.w;
        h = router.h;
    }

    public MapDisplay( int w, int h ) {
        System.out.println( w + " " + h );
        this.w = w;
        this.h = h;
        init();
        router.genRandomRadar( 20 );
    }

    public MapDisplay( int w, int h, int numRadar ) {
    System.out.println( w + " " + h + numRadar );
        this.w = w;
        this.h = h;
        init();
        router.genRandomRadar( numRadar );
    }

    public void init()
    {
        addMouseListener( this );
        setBackground( Color.black );
        router = new Router( w, h );
    }

    public void paintComponent( Graphics graphics ) {
        Graphics2D g = (Graphics2D) graphics;
        super.paintComponent( g );
        g.scale( (float) getWidth()     / (float) w,
                 (float) getHeight()    / (float) h );

        router.paintMap( g );

        g.setStroke( new BasicStroke(1/5) );
        
        g.setColor( Color.blue.darker().darker() );
        router.paintClosed( g );
        
        g.setColor( Color.magenta.darker().darker() );
        router.paintOpen( g );
        
        g.setStroke( new BasicStroke(1/2) );
        router.paintRoutes( g );

        g.setColor( Color.white );
        router.paintRoute( userRoute, g );

        //g.setColor( Color.red );
        //router.paintRoute( 0, g );
        /*
        g.setColor( Color.green );
        router.paintSplineRoute( 0, g );
        */
    }

    public Dimension getPreferredSize() {
        return new Dimension( 600, 600 );
    }

    public void mousePressed( MouseEvent e )
    {
    switch( e.getButton() ) {
        case( MouseEvent.BUTTON1 ):
            x[0] = (int) (e.getX() * w / getWidth() );
            y[0] = (int) (e.getY() * h / getHeight() );
            break;
        case( MouseEvent.BUTTON2 ):
            x[1] = (int) (e.getX() * w / getWidth() );
            y[1] = (int) (e.getY() * h / getHeight() );
            userRoute = new LinkedList();
            repaint();
            break;
        case( MouseEvent.BUTTON3 ):
            x[2] = (int) (e.getX() * w / getWidth() );
            y[2] = (int) (e.getY() * h / getHeight() );
            break;
        }
    }

    public void mouseReleased( MouseEvent e )
    {
        int x1, y1;
    switch( e.getButton() ){
        case ( MouseEvent.BUTTON1 ):
            x1 = (int) (e.getX() * w / getWidth() );
            y1 = (int) (e.getY() * h / getHeight() );
            router.findRoute( x[0], y[0], x1, y1 );
            repaint();
            break;
        case ( MouseEvent.BUTTON3 ):
            x1 = (int) (e.getX() * w / getWidth() );
            y1 = (int) (e.getY() * h / getHeight() );
            userRoute.add( new Location( x1, y1 ) );
            repaint();
            System.out.println( "total danger : " + router.map.dangerOnRoute( userRoute ) );
            break;
        }
    }

    public void mouseEntered( MouseEvent e )
    {

    }

    public void mouseExited( MouseEvent e )
    {

    }

    public void mouseClicked( MouseEvent e )
    {
        System.out.println( e.getButton() );
    }
 }   
