/**
    describes a position in the graph, however it is represented.
**/
public class Location implements Comparable
{
    /** x coordinate in space **/
    public int x;
    /** y coordinate in space **/
    public int y;
    /**
        constructor
        @param x x coordinate
        @param y y coordinate
    **/
    public Location( int x, int y ) {
        this.x = x;
        this.y = y;
    }
    /**
        @return (x,y)
    **/
    public String toString() {
        return "(" + x + "," + y + ")";
    }
    public int compareTo( Object rhs )
    {
        Location a = this;
        Location b = (Location) rhs;
        if( a.x > b.x ) return  1;
        if( b.x > a.x ) return -1;
        if( a.y > b.y ) return  1;
        if( b.y > a.y ) return -1;
        return 0;
    }
    public boolean equals( Object rhs ) { 
        Location b = (Location) rhs;
        return ( x == b.x && y == b.y );
    }
    public float distanceTo( Location b ) 
    {
        return (float) Math.sqrt( Math.pow( x-b.x,2) + Math.pow( y-b.y,2) );
    }
}
