import java.util.TreeMap;
import java.util.Collection;
class Open
{
    TreeMap keys;
    TreeMap locations;

    public Open(){
        keys = new TreeMap();
        locations = new TreeMap();
    }
    
    public String toString() {
        return "Keys: " + keys + "\n" + "Locations: " + locations + "\n";
    }

    public void put( Node node ){

        if( node == null ) return;
        Node n = (Node) locations.get( node.location );
        if( n != null )
            keys.remove( n.key );
        n = (Node) keys.get( node.key );
        if( n != null )
            locations.remove( n.location );
            
        keys.put( node.key, node );
        locations.put( node.location, node );
    }
    
    public Node get( Location l )    {
        return (Node) locations.get( l );
    }
    public Node get( Float v ) {
        return (Node) keys.get( v );
    }
    public void remove( Node n ) {
        remove( n.location );
    }
    public void remove( Location l ) {
        Node a = (Node) locations.remove( l );
        if( a != null)
            keys.remove( a.key );
    }

    public Node first() {
            return (Node) keys.get( keys.firstKey() );
    }

    public int size() {
        return keys.size();
    }
    public Node pop() {
        Node node = first();
        remove( node.location );
        return node;
    }
    
    public Collection values() {
        return locations.values();
    }
}
