import java.awt.*;
import java.applet.*;
import java.lang.*;

//////////////////////////////////////////////////////////////////////////
// class Environ
//////////////////////////////////////////////////////////////////////////
class Environ extends Canvas{
  
  public Obstacle Obs[];
  public Prey Food[];
  public Predator Robs[];
  public globals Gl;
  public boolean path = true;
  Graphics GC;

  Environ(Predator Robots[], Prey Foodparts[], Obstacle Obstacs[])
  {
    resize(300, 300);
    Obs = Obstacs;
    Food = Foodparts;
    Robs = Robots;
  }

  Environ(Predator Robots[], Prey Foodparts[], Obstacle Obstacs[], globals g)
  {
    Gl = g;
    resize(Gl.EnvX, Gl.EnvY);
    Obs = Obstacs;
    Food = Foodparts;
    Robs = Robots;

  }

  
  Environ getenv()
  {
    return this;
  }


  void PaintObs(Obstacle Obs[], int nobs)
  {
    int i;
    Graphics g = getGraphics();
    for(i = 1; i < nobs; i++)
      {
	System.out.print(" O" + i + ":("+
			 (int) Obs[i].x + "," +
			 (int) Obs[i].y + ")" );
	//	this.setForeground(Color.blue);
	g.setColor(Color.red);
	g.fill3DRect( Obs[i].x, Obs[i].y, 
		      Obs[i].width, 
		    Obs[i].height, true);
      }
    System.out.println(" ");
  }

  void PaintRobs(Predator robs[], int nbots)
  {
    int i;
    Graphics g = getGraphics();

    //    this.setForeground(Color.yellow);
    // g.setColor(Color.yellow);
    for(i = 0; i < nbots; i++)
      {
	//	System.out.println("NOPATH Bot " + i);
	g.setColor(getBackground());
 	if(robs[i].currentstep > 0)
 	  g.fillOval((int) robs[i].xmove[robs[i].currentstep - 1], 
 		     (int) (Gl.EnvY - robs[i].ymove[robs[i].currentstep] - 1), 
 		     Gl.predsize, Gl.predsize);

	g.setColor(Color.yellow);
	g.fillOval((int) robs[i].xmove[robs[i].currentstep], 
		   (int) (Gl.EnvY - robs[i].ymove[robs[i].currentstep]), 
		   Gl.predsize, Gl.predsize);
      }
  }


  void PaintPrey(Prey food[], int nfood)
  {
    int i;
    Graphics g = getGraphics();


    for(i = 0; i < nfood; i++)
      {
	//	System.out.print(" F"+i);
	if(!(food[i].eaten))
	  {
	    g.setColor(Color.green);
	    g.fillOval((int) food[i].x, (int) (Gl.EnvY - food[i].y), 
		       Gl.preysize, Gl.preysize);
	  }
	else
	  {
	    g.setColor(getBackground());
	    g.fillOval((int) food[i].x, (int) (Gl.EnvY - food[i].y), 
		       Gl.preysize, Gl.preysize);
	  }
      }
  }

  public void paint(Graphics g) 
  {
    //    System.out.println("In paint");
    //    System.out.flush();

    GC = g;

    PaintObs(Obs, Gl.nobs);
    PaintPrey(Food, Gl.nfood);
    if(path)
      PaintPath(Robs, Gl.nbots);
    else
      PaintRobs(Robs, Gl.nbots);
  }

  public void newpaint() 
  {
    //    clearScreen();
    //    PaintObs(Obs, Gl.nobs);
    //    System.out.println("In NEWPAINT " + Gl.nbots);
    //    System.out.flush();
    PaintPrey(Food, Gl.nfood);
    if (path)
      PaintPath(Robs, Gl.nbots);
    else
      PaintRobs(Robs, Gl.nbots);

  }

  void PaintPath(Predator robs[], int nbots)
  {
    int i, j;
  
    Graphics g = getGraphics();
    
    g.setColor(Color.yellow);
    for(i = 0; i < nbots; i++)
      {
	if (i % 3  ==  0)
	  g.setColor(Color.yellow);
	else if (i % 3 ==  1)
	  g.setColor(Color.blue);
	else if (i %3 == 2)
	  g.setColor(Color.green);
	else
	  g.setColor(Color.white);

	for(j = 0; j < robs[i].currentstep; j++)
	  {
	    g.fillRect( (int) robs[i].xmove[j], 
		       (int) (Gl.EnvY - robs[i].ymove[j]), 
		       Gl.predsize, Gl.predsize);
	    //	    System.out.print("R"+i+"("+(int) robs[i].xmove[j]
	    //			     +","+(int) (Gl.EnvY - robs[i].ymove[j])
	    //			     +") ");
	  }

      }
    //          System.out.println(" ");
  }

  void PaintPath(Predator robs[], int nbots, Graphics g)
  {
    int i, j;
  
    //Graphics g = getGraphics();
    
    g.setColor(Color.yellow);
    for(i = 0; i < nbots; i++)
      {
	for(j = 0; j < robs[i].currentstep; j++)
	  {
	    g.fillRect((int) robs[i].xmove[j], 
		       (int) (Gl.EnvY - robs[i].ymove[j]), 
		       Gl.predsize, Gl.predsize);
	    //	    System.out.print("R"+i+"("+(int) robs[i].xmove[j]
	    //			     +","+(int) (Gl.EnvY - robs[i].ymove[j])
	    //			     +") ");
	  }

      }
    //          System.out.println(" ");
  }

  public void clearAll() {
    //    
    //clearScreen();

  }
  
  public void clearScreen() {
    
    Graphics g = this.getGraphics();
    Rectangle r = this.bounds();
    g.setColor(this.getBackground());
    g.fillRect(r.x, r.y, r.width, r.height);
    g.setColor(this.getForeground());
  }



  
}



