import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;

//////////////////////////////////////////////////////////////////////////
// class Obs								//
//////////////////////////////////////////////////////////////////////////
class Obstacle extends Rectangle implements useful{ 		
  /* obstacle's structure */
  public int x1, x2;
  public int y1, y2;
  public int nobs;
  
  void setValues(int xx1, int xx2, int yy1, int yy2) {
    x1 = xx1;
    x2 = xx2;
    y1 = yy1;
    y2 = yy2;
  }
  int getx1() { return x1;}
  int getx2() { return x2;}
  int gety1() { return y1;}
  int gety2() { return y2;}
  

  Obstacle()
  {
    Random r = new Random(System.currentTimeMillis());
    
    x1 = 1 + r.nextInt() % EnvSize;
    y1 = 1 + r.nextInt() % EnvSize;

    x = (int) x1; /* for/from the rectangle class */
    y = (int) (EnvSize - y1);

    x2 = r.nextInt() % (int) (EnvSize - x1);
    y2 = r.nextInt() % (int) (EnvSize - y1);

    height = -1 * (int) y2; /* for/from the rectangle class */
    width = (int) x2;

    x2 = x1 + x2;
    y2 = y1 + y2;
    nobs++;

  }

  Obstacle(int sizex, int sizey, int w, int h)
  {/* makes the environment */
    x1 = sizex;
    y1 = sizey;
    x2 = x1 + w;
    y2 = y1 + h;

    x = x1;      /* for/from the rectangle class */
    y = EnvSize - y2;
    height = h;  /* for/from the rectangle class */
    width = w;

    nobs++;
  }

  Obstacle(int sizex, int sizey)
  {/* makes the environment */
    x1 = 0;
    y1 = 0;
    x2 = sizex;
    y2 = sizey;

    x = x1;      /* for/from the rectangle class */
    y = EnvSize - y2;
    width = Math.abs(x1 - x2);  /* for/from the rectangle class */
    height = Math.abs(y1 - y2);
    nobs++;
  }

  Obstacle(Obstacle obs[], int n)
  {
    Random r = new Random(System.currentTimeMillis());
    
    MakeRandomObs(obs, n, r);
    nobs++;
  }

  Obstacle(Obstacle obs[], int n, Random r)
  {

    MakeRandomObs(obs, n, r);
    nobs++;
  }

  void MakeRandomObs(Obstacle obs[], int n, Random r)
  {
    int num = 0;

    RectMake(r);
    while(overlap(this, obs, n) && num < 100)
      {
	System.out.println("Found an overlap");
	RectMake(r);
	num++;
      }
  }

  void RectMake(Random r)
  {
    x1 = Math.abs(r.nextInt()) % (EnvSize - ObsSize);
    y1 = Math.abs(r.nextInt()) % (EnvSize - ObsSize);
    
    x2 = x1 + (Math.abs(r.nextInt()) % ObsSize);
    y2 = y1 + (Math.abs(r.nextInt()) % ObsSize);

    x = x1; /* for/from the rectangle class */
    y = EnvSize - y2;
    height = Math.abs(y1 - y2); /* for/from the rectangle class */
    width = Math.abs(x1 - x2);
  }



  boolean overlap(Obstacle curr, Obstacle obs[], int n)
  {
    int i;
    for(i = 1; i < n; i++)
      {
	if(curr.intersects(obs[i]))
	  {
	    return true;
	  }
      }
    return false;
  }
	    
}
