import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;

//////////////////////////////////////////////////////////////////////////
// class Predator							//
//////////////////////////////////////////////////////////////////////////
public class Predator implements useful {	

/* only used in simulator */
  public double x[] = new double[nsensors];	
  /* sensor position */
  public double y[] = new double[nsensors]; 
  /* used 7 elements, 6 sensors + center */ 
  public double status[] = new double[nsensors];	
  /* status of the sensors */
  /* the degree between forward direction and horizon */
  public double xmove[] = new double[1000];
  public double ymove[] = new double[1000];
  public int motor[] = new int[nmotorbits];

  public int currentstep = 0;

  public void setxymove(double ix, double iy, int n)
  {
    xmove[n] = ix;
    ymove[n] = iy;

  }


  Predator(int ix, int iy, int SimStep)
  {
    x[0] = ix;
    y[0] = iy;
    //xmove[] = new double[SimStep];
    xmove[0] = ix;
    //ymove[] = new double[SimStep];
    ymove[0] = iy;
  }

  Predator(globals G)
  {
    int i;

    for(i = 0; i < G.nsensors; i++)
      {
	x[i] = y[i] = 0.0;
	status[i] = 0.0;
	if (i < G.nmotorbits) motor[i] = 0;
      }

    x[0] = 0.0;
    y[0] = 0.0;

    // xmove[] = new double[SimStep];
    xmove[0] = x[0];
    // ymove[] = new double[SimStep];
    ymove[0] = y[0];
    currentstep = 0;

  }

  Predator(Random r)
  {
    int i;

    for(i = 0; i < nsensors; i++)
      {
	x[i] = y[i] = 0.0;
	status[i] = 0.0;
	if (i < nmotorbits) motor[i] = 0;
      }

    x[0] = r.nextDouble() * EnvSize;
    y[0] = r.nextDouble() * EnvSize;

    xmove[0] = x[0];
    ymove[0] = y[0];
  }


  Predator(Obstacle Obs[], int nobs, Random r)
  {
    int i;

    for(i = 0; i < nsensors; i++)
      {
	x[i] = y[i] = 0.0;
	status[i] = 0.0;
	if (i < nmotorbits) motor[i] = 0;
      }

    MakePred(Obs, nobs, r);

  }

  void MakePred(Obstacle obs[], int nobs, Random r)
  {
    int n = 0;

    x[0] = r.nextDouble() * EnvSize;
    y[0] = r.nextDouble() * EnvSize;
    
    while (InsideObstacle( x[0], y[0], obs, nobs) && n < 100 ) 
      {
	System.out.print("Inside(" + (int) x[0] 
			 + "," + (int) y[0] + ")" );
	x[0] = r.nextDouble() * EnvSize;
	y[0] = r.nextDouble() * EnvSize;
	n++;
      }
    if (n == 100) 
      {
	x[0] = y[0] = EnvSize/2;
	System.out.println("BADPREDATOR (" + (int) x[0] + 
			   "," + (int) y[0] + ")" );
      }
    xmove[0] = x[0];
    ymove[0] = y[0];
  }

  boolean InsideObstacle(double x, double y, Obstacle obs[], int nobs)
  {
    int i;

     for (i = 1; i < nobs; i++)
       {
 	if (obs[i].inside((int) x, (int) (EnvSize - y))) 
 	  {
 	    return true;
 	  }
       }
     return false;
  }



}
