import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;

//////////////////////////////////////////////////////////////////////////
// class Prey								//
//////////////////////////////////////////////////////////////////////////
public class Prey implements useful{
  public double x, y;		/* the position of the prey */
  public double xmove[] = new double[SimStep], ymove[] = new double[SimStep];
  public double degree;    	/* between the forward direction and horizon */
  public boolean eaten;	/* 1 - eaten; 0 - not eaten */

  Prey(int ix, int iy)
  {
    x = ix;
    y = iy;
    eaten = false;
  }

  Prey(int ix, int iy, int SimStep)
  {
    x = ix;
    y = iy;
    xmove[0] = ix;
    ymove[0] = iy;
    eaten = false;
  }

  Prey()
  {
    Random r = new Random(System.currentTimeMillis());

    eaten = false;

    x = r.nextDouble() * EnvSize;
    y = r.nextDouble() * EnvSize;

    xmove[0] = x;
    ymove[0] = y;

  }

  Prey(Obstacle obs[], int nobs)
  {
    int n = 0;
    Random r = new Random(System.currentTimeMillis());

    eaten = false;

    //    System.out.println("Initing Food");
    MakePrey(obs, nobs, r);

    //    System.out.println("\nEnd Food");

  }

  void MakePrey(Obstacle obs[], int nobs, Random r)
  {
    int n = 0;

    x = r.nextDouble() * EnvSize;
    y = r.nextDouble() * EnvSize;
    //    System.out.print("(" + (int) x + "," + (int) y + ")" );
    while (InsideObstacle( x, y, obs, nobs) && n < 100 ) 
      {
	//	System.out.print("(" + (int) x + "," + (int) y + ")" );
	x = r.nextDouble() * EnvSize;
	y = r.nextDouble() * EnvSize;
	n++;
      }
    if (n == 100) 
      {
	eaten = true;
	x = y = EnvSize/2;
	System.out.println("BADPREY (" + (int) x + "," + (int) y + ")" );
      }
    xmove[0] = x;
    ymove[0] = y;
  }

  Prey(Obstacle obs[], int nobs, Random r)
  {
    int n = 0;

    eaten = false;
    //    System.out.println("Initing Food");

    MakePrey(obs, nobs, r);

    //    System.out.println("\nEnd Food");

  }

  boolean InsideObstacle(double x, double y, Obstacle obs[], int nobs)
  {
    int i;

     for (i = 1; i < nobs; i++)
       {
 	if (obs[i].inside((int) x, (int) (EnvSize - y))) 
 	  {
 	    return true;
 	  }
       }
     return false;
  }

  
  void setValues(double xx, double yy, double deg, boolean eat) {
    x = xx;
    y = yy;
    degree = deg;
    eaten = eat;
  }

  void setValues(double xx, double yy, double deg, boolean eat, int SimStep) {
    x = xx;
    y = yy;
    degree = deg;
    eaten = eat;
    xmove = new double[SimStep];
    xmove[0] = xx;
    ymove = new double[SimStep];
    ymove[0] = yy;
    
  }
  
  void clearEaten() { eaten = false; }
}
