#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include "control.h"

void dec_to_bin(int *, int, int);
void leftmotor(Predator *p, int speed);
void rightmotor(Predator *p, int speed);

void forward(Predator *p)
{
  leftmotor(p, FORWARD);
  rightmotor(p, FORWARD);
}

void FForward(Predator *p)
{
  leftmotor(p, FFORWARD);
  rightmotor(p, FFORWARD);
}


void turnleft(Predator *p)
{
  leftmotor(p, STOP);
  rightmotor(p, FFORWARD);
}

void turnright(Predator *p)
{
  rightmotor(p, STOP);
  leftmotor(p, FFORWARD);

}
  
void turnRright(Predator *p)
{
  rightmotor(p, FORWARD);
  leftmotor(p, REVERSE);
}
  
void turnLleft(Predator *p)
{
  leftmotor(p, FORWARD);
  rightmotor(p, REVERSE);
}
  

void leftmotor(Predator *p, int speed)
{
  int i;
  int bin[NMOTORBITS/2];

  dec_to_bin(bin, speed, NMOTORBITS/2);
  for (i = 0; i < NMOTORBITS/2; i++)
    {
      p->motor[LEFTMOTOR + i] = bin[i];
    }
}

void rightmotor(Predator *p, int speed)
{
  int i;
  int bin[NMOTORBITS/2];

  dec_to_bin(bin, speed, NMOTORBITS/2);
  for (i = 0; i < NMOTORBITS/2; i++)
    {
      p->motor[RIGHTMOTOR + i] = bin[i];
    }
}

void dec_to_bin(int *bin, int speed, int size)
{
  int i;
  for (i = 0; i < size; i++)
    {
      bin[i] = speed%2;
      speed = speed/2;
    }
}

