#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>

int dsock;
extern int nfood, nobs, nbots, steps;

int sockwrite(char *buf, int size, int fd);
void initbuf(char *p, int n);
void DispSockSend(char *buf, int len);
int sockread(char *buf, int size, int fd);
void DispSockRec(char *buf, int len);


void SendObsInfo(Obstacle obs[])
{
  int i;
  char sbuf[1024];
  int len;

  for(i = 0; i < nobs; i++)
    {
      initbuf(sbuf, 1024);
      sprintf(sbuf, "O %i %i %i %i %i \n",
	      i, obs[i].x1, obs[i].y1, obs[i].width, obs[i].height);
      len = strlen(sbuf);
      DispSockSend(sbuf, len);
    }
}

void SendNbots(int nbots)
{
  char sbuf[100];
  
  initbuf(sbuf, 100);
  sprintf(sbuf, "N %i %i \n", nbots, nbots*steps);
  DispSockSend(sbuf, strlen(sbuf));
}

void GetMessage(char *s)
{
  int len;
  len = strlen(s);
  DispSockRec(s, len);
}

int sockread(char *buf, int size, int fd)
{
  int n, c = 0;

  n = read(fd, buf, size);

  while (n < size && (c++ < 10)) 
    {
      n += read(fd, &buf[n], size - n);
      fprintf(stderr, 
              "\t\tBufRead:\n\t\t Had to read again %i\n", 
              n);
    }
  return n;
}

void DispSockRec(char *sbuf, int len)
{
  int ssize;
  char *rbuf = (char *) malloc(len + 1);

  do
    {
      initbuf(rbuf, len + 1);
      ssize = sockread(rbuf, len, dsock);
      if (ssize != len){
	fprintf(stderr, "size error in rec'ing data from display %i %i\n",
		len, ssize);
      }
    }
  while (strncmp(rbuf, sbuf, (size_t) len) != 0) ;
      
}


void SendPreyInfo(Prey Food[])
{
  int i;
  char sbuf[1024];
  int len;

  for(i = 0; i < nfood; i++)
    {
      initbuf(sbuf, 1024);
      sprintf(sbuf, "F %i %i %i \n",
	      i, Food[i].x, Food[i].y);
      len = strlen(sbuf);
      DispSockSend(sbuf, len);
    }
}

void initbuf(char *p, int n)
{
  int i;
  for(i = 0; i < n; i++) p[i] = '\0';
}
    

void SendDisplay(Predator *pred, Obstacle *ob, Prey *f, int time, int id)
{
  char sbuf[1024], *p;
  int i, len;

  for(i = 0; i < 1024; i++) sbuf[i] = '\0';

  sprintf(sbuf, "R %i %i %i %i ", id, time, 
	  (int) pred->x[0], (int) pred->y[0]);

  /*  fprintf(stdout, "R %i %i %i %i ", id, time, 
	  (int) pred->x[0], (int) pred->y[0]);
  
  fprintf(stdout, "double: %f %f ", pred->x[0], pred->y[0]);
  */

  len = strlen(sbuf);
  p = &sbuf[len];

  for(i = 0; i < nfood; i++)
    {
      sprintf(p, "%i ", f[i].eaten);
      /*      fprintf(stdout, "%i ", f[i].eaten); */
      len = strlen(sbuf);
      p = &sbuf[len];
    }
  sprintf(p, " \n");
  /* fprintf(stdout, " \n"); */
  
  DispSockSend(sbuf, strlen(sbuf));

}

void DispSockSend(char *buf, int len)
{
  int ssize;

  ssize = sockwrite(buf, len, dsock);
  if (ssize != len){
    fprintf(stderr, "size discrepancy in sending data to display %i %i\n",
	    len, ssize);
  }
}

int sockwrite(char *buf, int size, int fd)
{
  int n, c = 0;

  n = write(fd, buf, size);

  while (n < size && (c++ < 10)) 
    {
      n += write(fd, &buf[n], size - n);
      fprintf(stderr, 
              "\t\tBufWrite:\n\t\t Had to write again %i\n", 
              n);
    }
  return n;
}


void setsock(char *host, int port)
{
  struct sockaddr_in name;
  struct hostent *hp;

  dsock = socket(AF_INET, SOCK_STREAM, 0);
  
  if (dsock < 0) {
    perror("open error on socket");
    exit(1);
  }
  
  /* Get numeric address of machine  */
  hp = gethostbyname(host);

  name.sin_family = AF_INET;  
  bcopy((void *) hp->h_addr, (void *) &name.sin_addr.s_addr, hp->h_length); 
  name.sin_port = htons(port); /* for communicating with GATool */ 
    
  /* Create connection to socket on machine  */
  if (connect(dsock, (struct sockaddr *) &name, 
              sizeof(struct sockaddr)) < 0) 
    {
      perror("Cannot form connection to socket ...");
      exit(1);
    }
  fprintf(stderr, "Setup socket\n");
} 


