#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "control.h"
#include <sys/types.h>
#include <unistd.h>
#include <termios.h>

void foodapproach(Predator *p); /* util.c */
void sensorprint(Predator *p, char *s); /* in util.c */
void sushil(Predator *p, Obstacle *ob, Prey *f, int time, int k);
/* in this file */

void sensorfprintUser(FILE *fp, Predator *p, char *s);
void FPrintBatteryStates(FILE *fp, Predator *p, int n);
void actuatorfprint(FILE *fp, Predator *p, char*s);
void sensorfprint(FILE *fp, Predator *p, char *s);

void sushil(Predator *p, Obstacle *ob, Prey *f, int time, int k)
{
  int c, n;
  FILE *fp;
  static int speed = 2;
  static int flag = 0;
  struct termios st, *t;
  static char oldc = 'i';
  char tmp;


  /*  fprintf(stdout, "sushil: Trying to open %s for append\n", trainDataFile);*/ 

  fp = fopen("test.dat", "a");
  if(fp == NULL) {
    fprintf(stderr, "sushil: Error in opening %s for append\n", "test.dat");
    exit(1);
  }
  sensorfprintUser(stdout, p, " ");  
  sensorfprint(fp, p, "");  

  if(flag == 0) {
    t = &st;
    n = tcgetattr(0, t);
    t->c_lflag &= ~ICANON;
    t->c_cc[VMIN] = 0;
    t->c_cc[VTIME] = 1;
    tcsetattr(0, TCSANOW, t);
    flag++;
  }

  n = read(0, &tmp, 1);

  if(n > 0){
    c = (int) tmp;
    oldc = (int) tmp;
  } else {
    c = (int) 'z'; /*oldc;*/
  }

  fprintf(stdout, "Read \t %d bytes consisting of %c, %c, %c\n", n, tmp, oldc, c);

  fprintf(stdout, "Speed = %d\n", speed);

  switch (c) {
  case 'i': /* go forward */
    if(speed < FFORWARD) speed++;
    leftmotor(p, speed);
    rightmotor(p, speed);
    break;

  case 'j': /* turn left */
    leftmotor(p, REVERSE);
    rightmotor(p, FORWARD);
    c = (int) 'z';
    break;
 
  case 'l': /* turn right */
    leftmotor(p, FORWARD);
    rightmotor(p, REVERSE);
    c = (int) 'z';
    break;

  case 'm': /* slow down */
    if (speed > REVERSE) speed--;
    leftmotor(p, speed);
    rightmotor(p, speed);
    break;

  default:
    leftmotor(p, speed);
    rightmotor(p, speed);
    break;
  }

  actuatorfprint(fp, p, "");
  fclose(fp);

}
