#include "const.h"
#include "type.h"
#include <stdio.h>

Obstacle Obs[MAXOBS];
int nobs;


extern int EnvX, EnvY;
void SetEnv(Obstacle *O);
void makeObs(Obstacle *O, int n, FILE *fp);

void getObstacles(char *fname)
{
  FILE *fp;
  int i;

  if((fp = fopen(fname, "r")) == NULL)
    {
      perror("error in opening obstacle file");
    }

  fscanf(fp, "%i", &nobs); /* First obstacle is the environment */

  nobs++;
  SetEnv(&Obs[0]);

  for( i = 1; i < nobs; i++)
    {
      makeObs(&Obs[i], i, fp);
    }

}

void SetEnv(Obstacle *O)
{

  O->x1 = 0;
  O->y1 = 0;
  
  O->x2 = O->x1 + EnvX;
  O->y2 = O->y1 + EnvY;

  O->x = O->x1;
  O->y = EnvY - (O->y2);

  O->width = EnvX;
  O->height = EnvY;

}

void makeObs(Obstacle *O, int n, FILE *fp)
{
  int w, h;
  int x1, y1;

  fscanf(fp, "%i %i %i %i", &x1, &y1, &w, &h);

  O->x1 = x1;
  O->y1 = y1;
  
  O->x2 = x1 + w;
  O->y2 = y1 + h;

  O->x = x1;
  O->y = EnvY - (O->y2);

  O->width = w;
  O->height = h;
  fprintf(stderr, "Obs: %i %i %i %i\n", x1, y1, w, h);
}

  
