/****************************************************************************
* Robot Name: Dusty 
* Programmers: David Naney
	       Domagoj Podnar 
****************************************************************************/

#include <time.h>
#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "control.h"

void Crashed(Predator *p);
void foodApproach(Predator *p); /* util.c */
void sensorprint(Predator *p, char *s); /* in util.c */
void Dusty(Predator *p, Obstacle *ob, Prey *f, int time, int k);
/* in this file */

#define EPSILON 0.003

 
void Dusty(Predator *p, Obstacle *ob, Prey *f, int times, int kb)
{

    int i;
    static int j = 0;
    static int k = 0;
 
    if (k == 0) 
    {
        srandom((unsigned)time(0));
        k = 1;
    }
 
    i = random()%5;
    if ( crashed(p) == 0 && leftfront(p) == 0 && leftback(p) == 0 
        && rightfront(p)== 0 && rightback(p) == 0) 
    {   
        if (Battery(p) < 800)
        {
            foodApproach(p);
	    return;
        }

        if( i <= 2)
	{
	    leftmotor(p,2);
	    rightmotor(p,1);
	    return;	
	}
	else if( i > 2 )
	{
		leftmotor(p,1);
		rightmotor(p,2);
		return;
	}
	
    }
    else if ( crashed(p) == 1) 
             
    {       
 //	    j++;
 	    Crashed(p);
            return;
    }

    else if (rightfront(p) == 1 && leftfront(p) == 1  )
    {

       if (i <= 2)
        {
            leftmotor(p,0);
            rightmotor(p,0);
            return;
        }
        if ( i == 3)
        {
            leftmotor(p,2);
            rightmotor(p,1);
            return;
        }
        if ( i == 4)
        {
            leftmotor(p,1);
            rightmotor(p,2);
            return;
        }
    }
    if (leftback(p) == 1 )
    {
        leftmotor(p,2);
        rightmotor(p,1);
        return;
    }
    if (rightback(p) == 1)
    {
            leftmotor(p,1);
            rightmotor(p,2);
            return;
    }
    if (leftfront(p) == 1 )
    {
        leftmotor(p,1);
        rightmotor(p,0);
        return;
    }
    if (rightfront(p) == 1)
    {
            leftmotor(p,0);
            rightmotor(p,1);
            return;
    }

}
void foodApproach(Predator *p)
{
  int i;
  double left, right, diff;
 
  left = leftear(p);
  right = rightear(p);


  i = random()%5;

  if (leftfront(p) == 1 && rightfront(p) == 1)
  {
	if (i == 0)
	{
	    leftmotor(p,3);
            rightmotor(p,0);
	}
        if ( i <= 2)
        {
	    leftmotor(p,0);
	    rightmotor(p,3);
	}
        if ( i > 2)
	{
	    leftmotor(p,1);
	    rightmotor(p,2);
	    forward(p);
	}

  }

  diff = left - right;
  diff = (diff < 0 ? -1.0 * diff : diff);

  if ( diff < EPSILON )
    {
     forward(p);
    }
  else if(right  > left)
    {
      turnright(p);
    }
  else if(left > right)
    {
      turnleft(p);

    }
  else
    {

      forward(p);
    }

}

void Crashed(Predator *p)
{

    if ( crashed(p) == 1 && leftfront(p) == 0 && leftback(p) == 0
             && rightfront(p)== 0 && rightback(p) == 0)
    {
            leftmotor(p,0);
            rightmotor(p,0);
            return;
    }

    if (crashed(p) == 1 && leftfront(p) == 1 && rightfront(p) == 1)
    {
        leftmotor(p,0);
        rightmotor(p,0);
        return;
    }
    if (crashed(p) == 1 && leftfront(p) == 1 && leftback(p) == 1)
    {
        leftmotor(p, 3);
        rightmotor(p,2);
        return;
    }
    if (crashed(p) == 1 && rightfront(p) == 1 && rightback(p) == 1)
    {
        turnleft(p);
        return;
    }
    if (crashed(p) == 1 && leftback(p) == 1 && rightback(p) == 1)
    {
        leftmotor(p,2);
        rightmotor(p,2);
        return;
    }

}

