#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "control.h"

#define LT_FRO    0x0010
#define RT_FRO    0x0020
#define LT_REA    0x0040
#define RT_REA    0x0080
#define _CRASH    0x8000

#define _WANDER   0
#define _REV_LT   1
#define _REV_RT   2
#define _REVERS   3
#define _SPIRAL   4

#define _EAR_ZERO 0.00002

static int SPRESET = 1;

void foodapproach(Predator *p); /* util.c */
void sensorprint(Predator *p, char *s); /* in util.c */
void AA(Predator *p, Obstacle *ob, Prey *f, int time, int k);
/* in this file */

int getStatus(Predator* p);
void wander(Predator* p);
void wanderToFood(Predator* p);
void straight(Predator* p);
void spiralR(Predator* p);
void spiralL(Predator* p);
void wallFollow(Predator* p);

void AA(Predator *p, Obstacle *ob, Prey *f, int ftime, int k) {
  static int step = 0;
  static int stepType = _SPIRAL;
  int status = getStatus(p);
  srandom((unsigned)time(0) + ftime);
  if(status != 0) {
    if((status & LT_FRO) == LT_FRO) {
      stepType = _REV_LT;
      step = 0;
    }
    if((status & RT_FRO) == RT_FRO) {
      stepType = _REV_RT;
      step = 0;
    }
    if((status & _CRASH) == _CRASH) {
      stepType = _REVERS;
      step = 0;
    }
  }
  switch(stepType) {
  case _SPIRAL:
    if(Battery(p) > 700.0) {
      spiralL(p);
    }
    else {
      SPRESET = 1;
      wanderToFood(p);
    }
    break;
  case _WANDER:
    if(Battery(p) < 500.0) {
      wanderToFood(p);
      step++;
    }
    else if(step < 20) {
      wander(p);
      step++;
    }
    else if(step == 20) {
      SPRESET = 1;
      spiralR(p);
      step++;
    }
    else {
      spiralR(p);
      step++;
    }
    break;
  case _REV_LT:
    if(step < 2) {
      leftmotor(p, REVERSE);
      rightmotor(p, REVERSE);
      step++;
    }
    else if(step < 6) {
      leftmotor(p, STOP);
      rightmotor(p, REVERSE);
      step++;
    }
    else if(step < 8) {
      leftmotor(p, FORWARD);
      rightmotor(p, REVERSE);
      step++;
    }
    else {
      stepType = _WANDER;
      wander(p);
      step = 0;
    }
    break;
  case _REV_RT:
    if(step < 2) {
      leftmotor(p, REVERSE);
      rightmotor(p, REVERSE);
      step++;
    }
    else if(step < 6) {
      leftmotor(p, REVERSE);
      rightmotor(p, STOP);
      step++;
    }
    else if(step < 8) {
      leftmotor(p, REVERSE);
      rightmotor(p, FORWARD);
      step++;
    }
    else {
      stepType = _WANDER;
      wander(p);
      step = 0;
    }
    break;
  case _REVERS:
    if(step < 2) {
      leftmotor(p, REVERSE);
      rightmotor(p, REVERSE);
      step++;
    }
    else {
      stepType = _WANDER;
      wander(p);
      step = 0;
    }
  }
}

void straight(Predator* p) {
  static int step = 0;
  step++;
  if(step % 8 == 0) {
    leftmotor(p, FFORWARD);
    rightmotor(p, FORWARD);
    step = 0;
  }
  else {
    leftmotor(p, FFORWARD);
    rightmotor(p, FFORWARD);
  }
}

void wallFollow(Predator* p) {
  int status = getStatus(p);
  if(status) {
    leftmotor(p, FORWARD);
    rightmotor(p, REVERSE);
  }
  else straight(p);
}

void spiralR(Predator* p) {
  static long step = 0;
  static long turnStep = 0;
  static float stepLength = 1.0;
  if(SPRESET) {
    turnStep = step = 0;
    stepLength = 1.0;
    SPRESET = 0;
  }
  if(step < stepLength && step != -1) {
    straight(p);
    step++;
  }
  else if(step != -1){
    stepLength += 0.3;
    step = -1;
    turnStep = 0;
    leftmotor(p, FFORWARD);
    rightmotor(p, REVERSE);
  }
  else if(turnStep < 1) {
    leftmotor(p, FFORWARD);
    rightmotor(p, REVERSE);
    turnStep++;
  }
  else {
    step = 1;
    straight(p);
  }
}

void spiralL(Predator* p) {
  static long step = 0;
  static long turnStep = 0;
  static float stepLength = 1.0;
  if(SPRESET) {
    step = turnStep = 0;
    stepLength = 1.0;
    SPRESET = 0;
  }
  if(step < stepLength && step != -1) {
    straight(p);
    step++;
  }
  else if(step != -1){
    stepLength += 0.3;
    step = -1;
    turnStep = 0;
    rightmotor(p, FFORWARD);
    leftmotor(p, REVERSE);
  }
  else if(turnStep < 1) {
    rightmotor(p, FFORWARD);
    leftmotor(p, REVERSE);
    turnStep++;
  }
  else {
    step = 1;
    straight(p);
  }
}

void wander(Predator* p) {
  static int step = 0;
  step += random() % 7;
  step %= 9;
  switch(step) {
  case 0:
  case 1:
  case 2:
  case 3:
  case 4:
    forward(p);
    step++;
    break;
  case 5:
    turnLleft(p);
    step++;
    break;
  case 6:
    turnRright(p);
    step++;
    break;
  default:
    forward(p);
    step++;
    if(step > 8) step = 0;
  }
}

void wanderToFood(Predator* p) {
  double ltEar = leftear(p);
  double rtEar = rightear(p);
  if(ltEar > rtEar) {
    if(ltEar - rtEar < _EAR_ZERO) {
      straight(p);
    }
    else {
      rightmotor(p, FORWARD);
      leftmotor(p, STOP);
    }
  }
  else {
    if(rtEar - ltEar < _EAR_ZERO)  { 
      straight(p);
    }
    else {
      rightmotor(p, STOP);
      leftmotor(p, FORWARD);
    }
  }
}

int getStatus(Predator* p) {
  int result = 0x0000;
  if(leftfront(p)) result |= LT_FRO;
  if(rightfront(p)) result |= RT_FRO;
  if(leftback(p)) result |= LT_REA;
  if(rightback(p)) result |= RT_REA;
  if(crashed(p)) result |= _CRASH;
  return result;
}
