#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "control.h"

typedef struct SensorState {
  int lf;
  int rf;
  int lb;
  int rb;
  int crash;
  double lEar;
  double rEar;
}sensorState;

typedef struct RobotState {
  sensorState tripState;
  int timer;
  int mode;
  int prevMode;
  int manvMode;
  int manvTimer;
  int manvEndTime;
  int lastMoveDirection;
  int newManv;
  int totalTimer;
  int needFood;
  int foodSensed;
  int vari;
  int wallFollowDir;
  double earSum;
  int goAround;
  int hittingWalls;
  int lastHit;
  int silence;
} robotState;

void foodapproach(Predator *p); /* util.c */
void sensorprint(Predator *p, char *s); /* in util.c */
void c3i(Predator *p, Obstacle *ob, Prey *f, int time, int k);
/* in this file */
void HandleSensor( Predator *p, sensorState cur);
void SetCourse(Predator *p, sensorState cur);
int SensorTriped(sensorState cur);
void SeekFood(Predator *p, sensorState cur);
void Avoid(Predator *p, sensorState cur);
void ExeManeuver(Predator *p, sensorState cur);
void Scan(Predator *p, sensorState cur);
void RightReflect(Predator *p, sensorState cur);
void LeftReflect(Predator *p, sensorState cur);
void BackReflect(Predator *p, sensorState cur);
void RightFollow( Predator *p, sensorState cur);
void LeftFollow( Predator *p, sensorState cur);
void WallFollow( Predator *p, sensorState cur);
void SetManvMode(void);
void ClearManvMode(void);

static robotState lastState;

void c3i(Predator *p, Obstacle *ob, Prey *f, int time, int k)
{
  static initFunc = 0;
  sensorState curSensors;
  int getFood = 0;
  double temp;

  curSensors.lf = leftfront(p);
  curSensors.rf = rightfront(p);
  curSensors.lb = leftback(p);
  curSensors.rb = rightback(p);
  curSensors.crash = crashed(p);
  curSensors.lEar = leftear(p);
  curSensors.rEar = rightear(p);

  if(!initFunc)
  {
    lastState.timer = 0;
    lastState.mode = 0;
    lastState.prevMode = 0;
    lastState.manvMode = 0;
    lastState.lastMoveDirection = 0;
    lastState.newManv = 1;
    lastState.totalTimer = 1;
    lastState.foodSensed = 1;
    lastState.earSum = 0.0;
    lastState.wallFollowDir = 0;
    lastState.goAround = 0;
    lastState.hittingWalls = 0;
    lastState.lastHit = 0;
    lastState.silence = 0;
    initFunc = 1;
  }

  if( (curSensors.lEar > 0.0) || (curSensors.rEar > 0.0) )
  {
    lastState.silence = 0;
  }
  else lastState.silence = 1;

  if( (curSensors.lEar > 0.01) || (curSensors.rEar > 0.01) )
  {
    lastState.foodSensed++;
  }
  else lastState.foodSensed--;
  if(lastState.foodSensed > 500) lastState.foodSensed = 500;
  if(lastState.foodSensed < 1) lastState.foodSensed = 0;
  
  getFood = 1000 - lastState.foodSensed;

  if( Battery(p) < getFood ) lastState.needFood = 1;
  else lastState.needFood = 0;

  if( (lastState.totalTimer - lastState.lastHit) > 20 )
  {
    lastState.hittingWalls = 0;
  }
  else lastState.hittingWalls = 1;


  temp = (curSensors.lEar + curSensors.rEar) / 2;
  if( lastState.earSum > temp ) lastState.goAround++;
  else lastState.goAround--;
  if( temp == 0.0 ) lastState.goAround++;
  if(!(lastState.hittingWalls)) lastState.goAround -= 5;
  if( lastState.goAround > 15) lastState.goAround = 15;
  if( lastState.goAround < -10) lastState.goAround = -10;
  lastState.earSum = temp;


  if(lastState.mode != 2)
  {
    if( SensorTriped(curSensors) )
    {
      lastState.mode = 3;
      lastState.manvMode = 0;  //should be moved
      // set manvMode and set mode to maneuver
    }
    else
    {
      if( lastState.needFood )
      { 
        if(lastState.silence && (Battery(p) < 200) ) lastState.mode = 5;
	else
	{
	  if(lastState.goAround > 0) lastState.mode = 4;
	  else lastState.mode = 1;
	}
      }
      else lastState.mode = 0;
      // check if food is needed and set mode
      // else set mode to cover area     
    }
  }

  switch(lastState.mode)
  {
    case 0:  // Cover area
      SetCourse(p, curSensors);
      break;
    case 1:  // Look for food
      SeekFood(p, curSensors);
      break;
    case 2:  // execute maneuver
      ExeManeuver(p, curSensors);
      //HandleSensor(p, curSensors);
      break;
    case 3:  // handle sensor
      Avoid(p, curSensors);
      break;
    case 4:  // follow wall
      WallFollow(p, curSensors);
      break;
    case 5:
      Scan(p, curSensors);
      break;
    default:
      SetCourse(p, curSensors);
  }
  lastState.totalTimer++;
}

int SensorTriped(sensorState cur)
{
  if( cur.lf || cur.rf || cur.lb || cur.rb || cur.crash )
    return 1;
  else
    return 0;
}

void Avoid( Predator *p, sensorState cur)
{
//  int thisHit;
  int lf = cur.lf;
  int rf = cur.rf;
  int lb = cur.lb;
  int rb = cur.rb;
  int crash = cur.crash;
  
//  thisHit = lastState.totalTimer;
//  if( (thisHit - lastState.lastHit) > 20 ) lastState.hittingWalls = 0;
//  else lastState.hittingWalls = 1;
  lastState.lastHit = lastState.totalTimer;

  if(!lf && !rf && !lb && ! rb)  // case 0
		       // It must be the case that crash = 1
  {
    leftmotor(p, 0);
    rightmotor(p, 0);
  }
  if(lf && !rf && !lb && !rb)  // case 1
  {
    if(crash)
    {
      leftmotor(p, 0);
      rightmotor(p, 0);
    }
    else
    {
      if( lastState.needFood ) LeftFollow(p, cur);
      else RightReflect(p, cur);
    }
  }
  if(!lf && rf && !lb && !rb)  // case 2
  {
    if(crash)
    {
      leftmotor(p, 0);
      rightmotor(p, 0);
    }
    else
    {
      if( lastState.needFood ) RightFollow(p, cur);
      else LeftReflect(p, cur);
    }
  }
  if(!lf && !rf && lb && !rb)  // case 3
  {
    leftmotor(p, 2);
    rightmotor(p, 1);
  }
  if(!lf && !rf && !lb && rb)  // case 4
  {
    leftmotor(p, 1);
    rightmotor(p, 2);
  }
  if(lf && rf && !lb && !rb)  // case 5
  {
    if(crash)
    {
      leftmotor(p, 0);
      rightmotor(p, 0);
    }
    else
    {
      BackReflect(p, cur);
    }
  }
  if(!lf && !rf && lb && rb)  // case 6
  {
    // perhaps a new maneuver is needed here
    leftmotor(p, 2);
    rightmotor(p, 1);
  }
  if(lf && !rf && lb && !rb)  // case 7
  {
    leftmotor(p, 2);
    rightmotor(p, 1);
  }
  if(!lf && rf && !lb && rb)  // case 8
  {
    leftmotor(p, 1);
    rightmotor(p, 2);
  }
  if(lf && rf && !lb && rb)  // case 9
  {
    leftmotor(p, 1);
    rightmotor(p, 0);
  }
  if(lf && rf && lb && !rb)  // case 10
  {
    leftmotor(p, 0);
    rightmotor(p, 1);
  }
  if(lf && !rf && lb && rb)  // case 11
  {
    leftmotor(p, 3);
    rightmotor(p, 1);
  }
  if(!lf && rf && lb && rb)  // case 12
  {
    leftmotor(p, 1);
    rightmotor(p, 3);
  }
  if(lf && rf && lb && rb)  // case 13
  {
    leftmotor(p, 0);
    rightmotor(p, 2);
  }
//  lastState.mode = 0;  
}

void ExeManeuver(Predator *p, sensorState cur)
{
  switch(lastState.manvMode)
  {
    case 0:
      // no maneuver
      break;
    case 1:
      RightReflect(p, cur);
      break;
    case 2:
      LeftReflect(p, cur);
      break;
    case 3:
      BackReflect(p, cur);
      break;
    case 4:
      RightFollow(p, cur);
      break;
    case 5:
      LeftFollow(p, cur);
      break;
    default:
      break;
  }
}

void RightReflect(Predator *p, sensorState cur)
{
  if(lastState.newManv)  // init this function for the first time
  {
    SetManvMode();
    lastState.manvMode = 1; // This maneuver is in progress
    lastState.manvEndTime = 0 + (lastState.totalTimer % 3);
  }
  if(cur.lf)
  {
    leftmotor(p, 2);
    rightmotor(p, 0);
  }
  else
  {
    if(lastState.manvTimer <= lastState.manvEndTime)
    {
      leftmotor(p, 2);
      rightmotor(p, 0);
      lastState.manvTimer++;
    }
    else
    {
      lastState.vari = 0; // BackReflect will go left next time
      ClearManvMode();
      leftmotor(p, 2);
      rightmotor(p, 0);
    }
  }
}

void LeftReflect(Predator *p, sensorState cur)
{
  if(lastState.newManv)  // init this function for the first time
  {
    SetManvMode();
    lastState.manvMode = 2; // This maneuver is in progress
    lastState.manvEndTime = 0 + (lastState.totalTimer % 3);
  }
  if(cur.rf)
  {
    leftmotor(p, 0);
    rightmotor(p, 2);
  }
  else
  {
    if(lastState.manvTimer <= lastState.manvEndTime)
    {
      leftmotor(p, 0);
      rightmotor(p, 2);
      lastState.manvTimer++;
    }
    else
    {
      lastState.vari =1; // BackReflect will go right next time
      ClearManvMode();
      leftmotor(p, 0);
      rightmotor(p, 2);
    }
  }
}

void BackReflect(Predator *p, sensorState cur)
{
   if(lastState.newManv)  // init this function for the first time
  {
    SetManvMode();
    lastState.manvMode = 3;  // This maneuver is in progress
    lastState.manvEndTime = 5 + (lastState.totalTimer % 3);
  }
  if(lastState.manvTimer <= lastState.manvEndTime)
  {
    if(lastState.vari)  // vari =1 means right refection
    {
      leftmotor(p, 2);
      rightmotor(p, 0);
    }
    else
    {
      leftmotor(p, 0);
      rightmotor(p, 2);
    }
  }
  else
  {
    if(lastState.vari) lastState.vari = 0;
    else lastState.vari = 1;
    ClearManvMode();
    leftmotor(p, 2);
    rightmotor(p, 2);
  }
  lastState.manvTimer++;
}

void RightFollow( Predator *p, sensorState cur)
{
  if(lastState.newManv)  // init this function for the first time
  {
    SetManvMode();
    lastState.manvMode = 4;  // This maneuver is in progress
    lastState.manvEndTime = 0;  // not used
  }
  
  if( cur.rf )
  {
    leftmotor(p, 0);
    rightmotor(p, 2);
  }
  else
  {
    ClearManvMode();
    lastState.wallFollowDir = 1;
    leftmotor(p, 2);
    rightmotor(p, 2);
  }
}

void LeftFollow( Predator *p, sensorState cur)
{
  if(lastState.newManv)  // init this function for the first time
  {
    SetManvMode();
    lastState.manvMode = 5;  // This maneuver is in progress
    lastState.manvEndTime = 0;  // not used
  }
  
  if( cur.lf )
  {
    leftmotor(p, 2);
    rightmotor(p, 0);
  }
  else
  {
    ClearManvMode();
    lastState.wallFollowDir = 0;
    leftmotor(p, 2);
    rightmotor(p, 2);
  }
}

void SetManvMode(void)
{
    lastState.mode = 2;
    lastState.newManv = 0;
    lastState.manvTimer = 1;
}

void ClearManvMode(void)
{
  lastState.newManv = 1;
  lastState.manvMode = 0;
  lastState.mode = 0;
  lastState.manvTimer = 0;
  lastState.manvEndTime = 0;
}

void SetCourse(Predator *p, sensorState cur)
{
  double le = cur.lEar;
  double re = cur.rEar;
  double diff, mag;

  mag = (le + re) / 2;
  diff = le - re;
  diff = (diff < 0 ? -1.0 * diff : diff);

  if(0)
  {
    if( le > re )
    {
      leftmotor(p, 3);
      rightmotor(p, 2);
    }
    if( le < re )
    {
      leftmotor(p, 2);
      rightmotor(p, 3);
    }    
  }
  else
  {
    leftmotor(p, 3);
    rightmotor(p, 3);
  }
}

void SeekFood(Predator *p, sensorState cur)
{
  double le = cur.lEar;
  double re = cur.rEar;
  double diff;
  static int deOrbit = 0;
  double volume;

  diff = le - re;
  diff = (diff < 0 ? -1.0 * diff : diff);

  volume = (cur.lEar + cur.rEar) / 2;

  deOrbit++;

  if(volume < 0.95)
  {
    if( diff < 0.002 )
    {
      FForward(p);
    }
    else
    {
      if( le > re )
      {
	if(deOrbit > 5)
	{
	  leftmotor(p, 2);
	  rightmotor(p, 3);
	  deOrbit = 0;
	}
	else
	{
	  leftmotor(p, 1);
	  rightmotor(p, 2);
	}
      }
      if( le < re )
      {
	if(deOrbit > 5)
	{
	  leftmotor(p, 3);
	  rightmotor(p, 2);
	  deOrbit = 0;
	}
	else
	{
	  leftmotor(p, 2);
	  rightmotor(p, 1);
	}
      }
    }
  }
  else
  {
    if( diff < 0.0001 )
    {
      FForward(p);
    }
    else
    {
      if( le > re )
      {
	if(deOrbit > 5)
	{
	  leftmotor(p, 0);
	  rightmotor(p, 2);
	  deOrbit = 0;
	}
	else
	{
	  leftmotor(p, 1);
	  rightmotor(p, 2);
	}
      }
      if( le < re )
      {
	if(deOrbit > 5)
	{
	  leftmotor(p, 2);
	  rightmotor(p, 0);
	  deOrbit = 0;
	}
	else
	{
	  leftmotor(p, 2);
	  rightmotor(p, 1);
	}
      }
    }
  }
}

void WallFollow( Predator *p, sensorState cur)
{
  static int deOrbit = 0;

  deOrbit++;

  if(lastState.wallFollowDir)  // 1 = go right
  {
    if(deOrbit > 15)
    {
      leftmotor(p, 3);
      rightmotor(p, 0);
      deOrbit = 0;
    }
    else
    {
      leftmotor(p, 2);
      rightmotor(p, 1);
    }
  }
  else  // 0 = go left
  {
    if(deOrbit > 15)
    {
      leftmotor(p, 0);
      rightmotor(p, 3);
      deOrbit = 0;
    }
    else
    {
      leftmotor(p, 1);
      rightmotor(p, 2);
    }
  }
}

void Scan(Predator *p, sensorState cur)
{
  static int step = 0;

  step++;

  if(step < 4)
  {
    if(!lastState.wallFollowDir)
    {
      leftmotor(p, 2);
      rightmotor(p, 1);
    }
    else
    {
      leftmotor(p, 1);
      rightmotor(p, 2);
    }
  }
  else
  {
    if(!lastState.wallFollowDir)
    {
      leftmotor(p, 2);
      rightmotor(p, 0);
    }
    else
    {
      leftmotor(p, 0);
      rightmotor(p, 2);
    }
  }
  if(step > 18) step = 0;
}
