//==============================================================
// Group 3 = R2D2
// (Johnson, Sagun)
// AI Competition#2: Maximum area.
// April 7, 1998
// -----------------------------
// Filename: r2d2.c
// Function: r2d2(Predator *p, Obstacle *ob, Prey *f, int time, int k)
//==============================================================
#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "control.h"

void foodapproach(Predator *p); /* util.c */
void sensorprint(Predator *p, char *s); /* in util.c */
//int r2d2counter;

/* In this file */
void r2d2(Predator *p, Obstacle *ob, Prey *f, int time, int k);

void r2d2(Predator *p, Obstacle *ob, Prey *f, int time, int k)
{
      int aseed; //aseed = r2d2counter%10;  
      srandom(time);
      aseed = random()%10;  //aseed is random number, NOT seed
   
    //=================================================
    // No sensory input.  Where the whole algorithm is.
    // ------------------------------------------------
    //
    //
    //=================================================
    if( !leftback(p) && !leftfront(p) && 
	!rightback(p) && !rightfront(p) )
    {
	if (p->status[0] == 1) // A crash into a corner (special case)
             turnright(p); 

	else if(Battery(p)>800)   // Lots of food.  Don't look for it
         {			  // Highly random turning.
	    if (aseed>5)	  // 50% forward, 20% left, 30% right
              forward(p);

             else if(aseed>2)
               turnleft(p);

              else
                turnright(p);

         }

        else if(Battery(p)>400)   // Getting low on food. Look more.
         {
    
              if(aseed>8)         // 10% left, 10% right, 80% find food
                turnleft(p);
        
              else if(aseed>7)
                 turnright(p);

              else
               {
                  if (leftear(p) > rightear(p))
                    turnleft(p);  
                   else if (leftear(p) < rightear(p))
                     turnright(p);
                     else
                      forward(p);
               }
        
         } 

        else 					// Need food
         { 
             if (leftear(p) > rightear(p))      // Exclusively find food.
                turnleft(p);
	       else if (leftear(p) < rightear(p))
		 turnright(p);
	           else 
		    forward(p);
          }
    }

    // Turn left if there is something in front (head on)
    else if( leftfront(p) && !leftback(p) && 
	     rightfront(p) && !rightback(p) )
    {
	leftmotor(p, STOP);  rightmotor(p, REVERSE);
    }
   
    // Move left if detects only front right
    else if( !leftfront(p) && !leftback(p) && 
	     rightfront(p) && !rightback(p) )
    {
	leftmotor(p, REVERSE);  rightmotor(p, STOP);
    }
 
    // Move right if it only detect front left 
    else if( leftfront(p) && !leftback(p) && 
	     !rightfront(p) && !rightback(p) )
    {
	leftmotor(p, STOP);  rightmotor(p, REVERSE);
    }

    // Stuck in right corner
    else if( leftfront(p) && !leftback(p) &&
	     rightfront(p) && rightback(p) )
    {
	leftmotor(p, STOP);  rightmotor(p, REVERSE);
    }


    // Stuck in left corner
    else if( leftfront(p) && leftback(p) &&
	     rightfront(p) && !rightback(p) )
    {               
         // leftmotor(p, REVERSE);  rightmotor(p, STOP);
          turnright(p);
    }


    // Backed into left corner
    else if( leftfront(p) && leftback(p) &&
             !rightfront(p) && rightback(p) )
    {
	leftmotor(p,FORWARD); rightmotor (p, FORWARD);
    }

    // Backed into right corner
    else if( !leftfront(p) && leftback(p) &&
              rightfront(p) && rightback(p) )
    {	
	leftmotor(p, FORWARD);  rightmotor(p, FORWARD);
    }

    // Back Left sensor only
    else if( !leftfront(p) && leftback(p) &&
	     !rightfront(p) && !rightback(p) )
    {
	forward(p);
    }

    // Back Right sensor only
    else if( !leftfront(p) && !leftback(p) &&
	!rightfront(p) && rightback(p) )
    {
          leftmotor(p, STOP);  rightmotor(p, FORWARD);
    }

    // Back-up head-on
    else if( !leftfront(p) && leftback(p) &&
	!rightfront(p) && rightback(p) )
    {
       forward(p);
    }

   // Both Left Sensors
    else if( leftfront(p) && leftback(p) &&
	!rightfront(p) && !rightback(p) )
    {
	leftmotor(p,FORWARD);  rightmotor(p, STOP);
    }


    // Both Right Sensors
    else if( !leftfront(p) && !leftback(p) &&
	rightfront(p) && rightback(p) )
    {
	leftmotor(p,STOP);  rightmotor(p,FORWARD);

    }

    // Diagonals
    else if( !leftfront(p) && leftback(p) &&
	     rightfront(p) && !rightback(p) )
    {
	turnLleft(p);
    }

    else if( leftfront(p) && !leftback(p) &&
	     !rightfront(p) && rightback(p) )
    {
	turnRright(p);   
    }

    // ALL FOURS
    else if( leftfront(p) && leftback(p) &&
	     rightfront(p) && rightback(p) )
    {
	printf ("AAACCK!!!! No way out!!\n");   
    }

    else   // I this even really tecnically possible?
    {
	turnleft(p);
    }
}

