#include "const.h"
#include "type.h"
#include <stdio.h>

Predator Robs[MAXBOTS];
int nbots;

void makeRobs(Predator *p, int which, FILE *fp);

void getPredator(char *fname)
{
  FILE *fp;
  int i;

  if((fp = fopen(fname, "r")) == NULL)
    {
      perror("Unable to open Robot file");
    }
  
  fscanf(fp, "%i", &nbots);

  for(i = 0; i < nbots; i++)
    {
      makeRobs(&Robs[i], i, fp);
    }
}

void makeRobs(Predator *p, int which, FILE *fp)
{
  int i;

  p->id = which;
  p->ate = 0;
  p->touch = 0;
  p->hit = 0;
  p->dist = 0.0;
  p->crash = 0;
  p->battery = FULLBAT;

  for(i = 0; i < NSENSORS; i++)
    {
      p->status[i] = 0.0;
      p->x[i] = p->y[i] = 0.0;
    }
  for(i = 0; i < NMOTORBITS; i++)
    p->motor[i] = 1; /* default: go forward */

  p->NewAngle = 0.0;
  p->NewStep = 0.0;
  p->currentstep = 1;

  fscanf(fp, "%lf %lf %lf", &(p->x[0]), &(p->y[0]), &(p->deg));
  p->xmove[0] = p->x[0];
  p->ymove[0] = p->y[0];
  fprintf(stderr, "Rob %f %f %f\n", (p->x[0]), (p->y[0]), (p->deg));
}
