#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <sys/types.h>
#include <fcntl.h>

int EnvX = 300;
int EnvY = 300;
int EAR[2] = {5, 6};
double touchWhiskLength = 6.0;
double hearWhiskLength = 5.0;
Area cover[MAXBOTS];

extern Predator Robs[MAXBOTS];
extern Obstacle Obs[MAXOBS];
extern Prey Food[MAXFOOD];
extern char *obsfile;
extern char *preyfile;
extern char *predfile;
extern int nfood;
extern int nbots;
extern int nobs;
extern double SoundRange;
extern int FoodLength;
extern int DEADTIME;

int flip(double);
void fitnessprint(Predator *p, int nbots);
void getMotorCommands(Predator *p, Obstacle *ob, Prey *f, 
		      int time, int k);
void sendStatus(Predator *p, Obstacle *ob, Prey *f, 
		int time, int cflag, int k);

void control(Predator *p, Obstacle *ob, Prey *f, int time, int k);
void SendDisplay(Predator *pred, Obstacle *ob, Prey *f, int time, int id);

void scramble(int *who, int n);
void swap(int *x, int *y);
void simulate(int display, int extcontrol, int ncontrols, int nsteps);
void GetAction(Predator *p, Obstacle *ob, Prey *f, 
	       int time, int cflag, int k);
void SendAction(Predator *p, Obstacle *ob, Prey *f, 
		int time, int cflag, int k);
void SensorPosition(Predator *rob, Obstacle *Obs, Prey *Food, int simstep);
void SensorStatus(Predator *Rob, Obstacle *Obs, Prey *Food, int simstep);
void CheckCollisions(Predator *rob, double degree, 
		     double step, Obstacle *Obs, int curstep) ;
double noise(double value);
int crossObstacle(double x1[], double y1[],
		    double x2, double y2, Obstacle obs) ;
int crossPoint(double xx[], double yy[], int index, 
		 double x11, double y11,
		 double x12, double y12,
		 double x21, double y21,
		 double x22, double y22 );

double smaller(double x, double y) ;
double bigger(double x, double y);
double distance(double x1, double y1, double x2, double y2);
int feel1(double x, double y, int i, Obstacle obs[]);
int feel(double x, double y, Obstacle obs[]);
void CanEat(Predator *rob,  Obstacle Obs[], Prey Food[], int step);
void sensorprint(Predator *p, char *s);
void PrintBatteryStates(Predator *p, int n);

void scramble(int *who, int n)
{
  int i;
  for (i = 0; i < n; i++)
    who[i] = i;

  for(i = 0; i < n/2; i++)
    swap(&who[random()%n], &who[random()%n]);
}

void swap(int *x, int *y)
{
  int tmp;
  tmp = *x;
  *x = *y;
  *y = tmp;
}

void simulate(int display, int extcontrol, int ncontrols, int nsteps)
{
  int i, j, k;

  int who[MAXBOTS];

  for(k = 0; k < MAXBOTS; k++)
    {
      for(i = 0; i < EnvX; i++)
	{
	  for(j = 0; j < EnvY; j++)
	    {
	  cover[k].area[i][j] = 0;
	    }
	}
    }
  for(i = 0; i < ncontrols; i++)
    {
      SensorPosition(&Robs[i], Obs, Food, 0);
      SensorStatus(&Robs[i], Obs, Food, 0);
      if (display)
	SendAction(&Robs[i], Obs, Food, 0, extcontrol, i);
    }

  for(i = 1; i <= nsteps; i++)
    {

      /*      usleep(50000);*/
           fprintf(stderr, "Start Step %i ", i);
      scramble(who, ncontrols);
      for(j = 0; j < ncontrols; j++)
	{
	  k = who[j];

	  GetAction(&Robs[k], Obs, Food, i, extcontrol, k);
	  	  fprintf(stderr, "."); 

	  if(Robs[k].battery > 0.0) {  /* no juice */
	    SensorPosition(&Robs[k], Obs, Food, i);
	    fprintf(stderr, ".");
	    
	    SensorStatus(&Robs[k], Obs, Food, i);
	    fprintf(stderr, ".");
	    
	    CanEat(&Robs[k], Obs, Food, i); 
	    fprintf(stderr, ".");
	    
	    Robs[k].currentstep = i;
	    cover[k].area[(int)Robs[k].x[0]][(int)Robs[k].y[0]] = 1;
	  }

	  if (display)
	    SendAction(&Robs[k], Obs, Food, i, extcontrol, k);
	  fprintf(stderr, ".");
	}
      fprintf(stderr, "End step %i\n", i);
      PrintBatteryStates(Robs, ncontrols);
    }
  fitnessprint(Robs, ncontrols);

}


void GetAction(Predator *p, Obstacle *ob, Prey *f, 
	       int time, int cflag, int k)
{
  if(cflag)
    getMotorCommands(p, ob, f, time, k);
  else 
    control(p, ob, f, time, k);
}

void SendAction(Predator *p, Obstacle *ob, Prey *f, 
		int time, int cflag, int k)
{
  if(cflag)
    sendStatus(p, ob, f, time, cflag, k); 
  SendDisplay(p, ob, f, time, k);
}


void SensorStatus(Predator *rob, Obstacle *Obs, Prey *Food, int simstep)
{
  int i, j;
  double range, d;
  
  /* the status of the centor sensor has been set in sensorPosition() */
  
  for (i = 1; i <= 4; i++)
    if (rob->x[i] < 0) 
      { /* touched */
	rob->status[i] = 1;
	rob->touch++;
      }
    else
      {
	rob->status[i] = 0;
      }
  if (rob->status[0] == 1)
    {
      rob->hit++;
    }
  /* the max effective range of the food               */
  range = SoundRange;
  
  /* if the ears are touched by any obstacles,       */
  /* set the ear position to the center of robot (rob->x[0], rob->y[0]) 
     WHY WHY WHY WHY WHY? */
  /************
    for (i = 0; i < 2 ; i++) 
    if (rob->x[EAR[i]] < 0) 
    {        
    rob->x[EAR[i]] = rob->x[0];
    rob->y[EAR[i]] = rob->y[0];
    }
    ***********************/
  /* the strength in each hearing sensor */
  for (i = 0; i < 2; i++) 
    {
      rob->status[EAR[i]] = 0; 
      /* the hearing strength of the ith ear */
      for(j = 0; j < nfood; j++)
	{
	  if((Food[j].eaten) == 0)
	    {
	      d = distance(rob->x[EAR[i]],
			   rob->y[EAR[i]],
			  (double) Food[j].x, 
			   (double) Food[j].y);
	      if (d <= range && d > 0) 
		{
		  rob->status[EAR[i]] += (range / (d * d));
		}
	    }
	}
    }
  /* sensorprint(rob, "Sensor "); */
} /* end sensorStatus() */


void SensorPosition(Predator *Rob, Obstacle *Obs, Prey *Food, int simstep)
{
  double Lmotor, Rmotor;
  
  Lmotor = (double)(Rob->motor[0] +  Rob->motor[1]*2.0) - 2.0 ;
  Rmotor = (double)(Rob->motor[2] + Rob->motor[3]*2.0) - 2.0 ;
  /* turn left -- positive degree   */
  /* turn right -- negative degree  */
  Rob->NewAngle = (Rmotor - Lmotor) * 10.0;
  /* step will be 2, 3, 4, 5, 6, 7, or 8 */
  Rob->NewStep =  Lmotor + Rmotor + 2.0;

  if (Rob->NewStep < 0.0) {
    Rob->battery += Rob->NewStep;
  } else {
    Rob->battery -= Rob->NewStep;
  }
  if(Rob->battery <= 0.0)
    Rob->battery = -1.0;

  /* 
  if(Rob->battery <= 0.0) {
    Rob->NewStep  = 0;
    Rob->NewAngle = 0;
    Rob->battery = -1.0;
  }
  */
  CheckCollisions(Rob, Rob->NewAngle, Rob->NewStep, Obs, simstep);
  
}

void CheckCollisions(Predator *rob, double degree, 
		     double step, Obstacle *Obs, int curstep) 
{
  int i, crash, crossPointNumber;	

  double xOld, yOld, dx, dy;
  double angle;
  double xx[1], yy[1];
  
    /* the OLD position of the center sensor */
  xOld = rob->x[0];
  yOld = rob->y[0];
  /* turn the rotation degree around the center axial */
  rob->deg += degree + noise(degree); /*add noise that's some % of degree*/
  if (rob->deg > 180) 
    rob->deg = -360 + rob->deg;
  if (rob->deg < -180) 
    rob->deg = 360 + rob->deg;
  /* go step's unit along the NEW forward direction  */
    angle = rob->deg * pi / 180.0;
    rob->x[0] += (step + noise(step)) * cos(angle);
    rob->y[0] += (step + noise(step)) * sin(angle);


    xx[0] = rob->x[0];
    yy[0] = rob->y[0];
    /* IF crashed, set (rob->x[0],rob->y[0]) as the       */
    /* crashed point and return the actual step length */
    crash = 0;
    for (i = 0; i < nobs; i++) 
      {
	crossPointNumber = crossObstacle(xx, yy, xOld, yOld, 
					 Obs[i]);
	if ((feel1(xOld, yOld, i, Obs) == 1) 
	    && (feel1(xx[0], yy[0], i, Obs) == 0) 
	    &&  (crossPointNumber == 1)) 
	  {
	    /* NO crosspoints other than the start point */
	    xx[0] = rob->x[0];
	    yy[0] = rob->y[0];
	  }
	else
	  {/* the stop point will be (xx, yy) */
	    crash += crossPointNumber;
	  }
      }
    
    if (crash > 0) 
      {   /* crashed with at least one obstacles or boundary */
	rob->x[0] = xOld;      /* set robot to the crashed point */
	rob->y[0] = yOld;
	step = 0.0;
	rob->status[0] = 1;
	rob->crash = 1;
      }
    else
      {/* NOT crashed */
	rob->status[0] = 0;
	rob->crash = 0;
      }

    
    if(step >= 0) {
      rob->dist += step;
    } else {
      rob->dist -= step;
    }

    rob->ymove[curstep] = rob->y[0];
    rob->xmove[curstep] = rob->x[0];
    
    /* the positions of the touch sensor */
    angle = ( rob->deg + 30 ) * pi / 180.0;
    dx = touchWhiskLength * cos(angle);
    dy = touchWhiskLength * sin(angle); 
                                /*   |<-- forward direction  */
    rob->x[1] = rob->x[0] + dx;	/*       1  \ | /  3<-- touch sencer  */
    rob->y[1] = rob->y[0] + dy; /*           \|/                      */
    rob->x[4] = rob->x[0] - dx; /*      5 ----0----  6<-- hear sensor */
    rob->y[4] = rob->y[0] - dy; /*           /|\                      */
                                /*       2  / | \  4<-- touch sensor  */
    angle = ( rob->deg - 30 ) * pi / 180.0;
    dx = touchWhiskLength * cos(angle);
    dy = touchWhiskLength * sin(angle);
    rob->x[2] = rob->x[0] - dx;
    rob->y[2] = rob->y[0] - dy;
    rob->x[3] = rob->x[0] + dx;
    rob->y[3] = rob->y[0] + dy;
    
    /* the positions of the hearing sensors */
    angle = ( rob->deg + 90 ) * pi / 180.0;
    dx = hearWhiskLength * cos(angle);
    dy = hearWhiskLength * sin(angle);
    rob->x[5] = rob->x[0] + dx;
    rob->y[5] = rob->y[0] + dy;
    rob->x[6] = rob->x[0] - dx;
    rob->y[6] = rob->y[0] - dy;
    
    /* IF the sensor touch any obstacles,   */
    /* modify the sensor position           */
    for (i = 1; i < NSENSORS; i++) 
      {
	if (feel(rob->x[i], rob->y[i], Obs) >= 0) 
	  {  /* touched */
	    rob->x[i] = -1;
	    rob->y[i] = -1;

	  }
      }

  }  
  
  /********************************************************************/
  /* noise()								*/
  /********************************************************************/
double noise(double value) 
  {
    return 0.0;
    /*return (flip((double)0.5) ? (double) -1.0: (double) 1.0); */
  }
  
  /********************************************************************/
  /* crossObstacle()							*/
  /********************************************************************/
int crossObstacle(double x1[], double y1[],
		    double x2, double y2, Obstacle obs) 
  {
    int i, j;
    double a, min;
    double xCross[4], yCross[4];

    i = 0;                /* the number of the cross points */
    i += crossPoint(xCross, yCross, i, x2, y2, x1[0], y1[0],
         	    (int) obs.x1, (int) obs.y1, (int) obs.x1, (int) obs.y2);

    i += crossPoint(xCross, yCross, i, x2, y2, x1[0], y1[0],
        	    obs.x1, obs.y2, obs.x2, obs.y2);

    i += crossPoint(xCross, yCross, i, x2, y2, x1[0], y1[0],
        	    obs.x2, obs.y2, obs.x2, obs.y1);

    i += crossPoint(xCross, yCross, i, x2, y2, x1[0], y1[0],
        	    obs.x2, obs.y1, obs.x1, obs.y1);


    if (i != 0) {         /* crosssed */
      x1[0] = xCross[0];
      y1[0] = yCross[0];
      min = distance(x2, y2, xCross[0], yCross[0]);
      for (j = 1; j < i; j++) {
	a = distance(x2, y2, xCross[j], yCross[j]);
	if (a < min) {
	  min = a;
	  x1[0] = xCross[j];
	  y1[0] = yCross[j];
	}
      }
    }
    
    return i;             /* i = 0: NOT crashed;   i > 0 : crashed */
  }
  
  /********************************************************************/
  /* crossPoint()							*/
  /********************************************************************/
int crossPoint(double xx[], double yy[], int index, 
		 double x11, double y11,
		 double x12, double y12,
		 double x21, double y21,
		 double x22, double y22 ) {
    
    double x1Low, x1High, y1Low, y1High;
    double x2Low, x2High, y2Low, y2High;
    double x, y, a;
    
    x1Low = smaller( x11, x12 );
    x1High = bigger( x11, x12 );
    y1Low = smaller( y11, y12 );
    y1High = bigger( y11, y12 );
    
    x2Low = smaller( x21, x22 );
    x2High = bigger( x21, x22 );
    y2Low = smaller( y21, y22 );
    y2High = bigger( y21, y22 );
    
    /****** check whether there is wrong calling format ****/
    if ((x21-x22)*(y21-y22) != 0) 
      {
	printf("ERROR in crossPoint()!");
	return 0;
      }
    
    /*********** normal cases **************/
    if ((x11-x12)*(y11-y12) != 0) 
      {
	a = (y11 - y12) / (x11 - x12);
	
	if (x21 == x22) 
	  {
	    if (x21 >= x1Low && x21 <= x1High) 
	      {
		x = x21;
		y = a * (x - x11) + y11;
		if (y >= y2Low && y <= y2High) 
		  {
		    xx[index] = x;
		    yy[index] = y;
		    return 1;
		  }
	      }
	  }
	else 
	  {  /* y21 == y22 */
	    if (y21 >= y1Low && y21 <= y1High) 
	      {
		y = y21;
		x = (y - y11) / a + x11;
		if (x >= x2Low && x <= x2High) 
		  {
		    xx[index] = x;
		    yy[index] = y;
		    return 1;
		  }
	      }
	  }
	return 0;
      } /* end normal cases */
    
    /************** special cases *****************/
    else 
      {
	if (x11 == x12) {            /* the first line is a horizen line */
	  if (x21 == x22 && x11 == x21 &&       /* two overlopped */
	      y12 >= y2Low && y12 <= y2High) {  /* stright lines  */
	    
	    xx[index] = x12;
	    yy[index] = y12;
	    return 1;
	  }
	  if (y21 == y22 &&           /* two crossed prependical lines */
	      x11 >= x2Low && x11 <= x2High &&
	      y21 >= y1Low && y21 <= y1High) {
	    
	    xx[index] = x12;
	    yy[index] = y21;
	    return 1;
	}
	  return 0;                         /* NO cross point */
      }
	if (y11 == y12) {        /* the first line is a prependical line */
	  if (y21 == y22 && y11 == y21 &&        /* two overlopped */
	      x12 >= x2Low && x12 <= x2High ){   /* stright lines  */
	    
	    xx[index] = x12;
	    yy[index] = y12;
	  return 1;
	  }
	  if (x21 == x22 &&           /* two crossed prependical lines */
	      y11 >= y2Low && y11 <= y2High &&
	      x21 >= x1Low && x21 <= x1High) {
	    
	  xx[index] = x21;
	  yy[index] = y11;
	  return 1;
	  }
	  return 0;                         /* NO cross point */
	}    
      } /* end special cases */
    
    return 2;		/* never got here, just for compiling error */
} 
/* end crossPoint() */

  /********************************************************************/
  /* smaller()							*/
/********************************************************************/
double smaller(double x, double y) {
  if (x < y)
    return x;
  else
    return y;
}

  /********************************************************************/
  /* bigger()								*/
  /********************************************************************/
double bigger(double x, double y) {
  if (x > y) 
    return x;
  else
    return y;
}
  
/********************************************************************/
/* distance()							*/
/********************************************************************/
double distance(double x1, double y1, double x2, double y2) 
{
  return sqrt((double) ((x1-x2)*(x1-x2) + (y1-y2 )*(y1-y2)));
}
  
  /********************************************************************/
  /* feel1()								*/
  /********************************************************************/
int feel1(double x, double y, int i, Obstacle obs[]) 
  {
    if (i != 0)
      {                          /* NOT the boundary */
	if ((x >= obs[i].x1) && /* contact with obstacle */
	    (x <= obs[i].x2) &&
	    (y >= obs[i].y1) && 
	    (y <= obs[i].y2))
	  {
	    return 1;         
	  }
      }
    else
      {/* the boundary */
	if ((x <= obs[0].x1) ||
	    (x >= obs[0].x2) ||
	    (y <= obs[0].y1) || 
	    (y >= obs[0].y2)) 
	  return 1;
      }
    return 0;			      /* No contact */
  }
  
  /********************************************************************/
  /* feel()								*/
  /********************************************************************/
int feel(double x, double y, Obstacle obs[]) {
    int i;
    
    for (i = 1; i < nobs; i++) 
      {
	if (x >= obs[i].x1 &&    /* contact with obstacle */
	    x <= obs[i].x2 &&
	    y >= obs[i].y1 &&
	    y <= obs[i].y2 ) 
	  {
	    return i;
	  }
      }
    /* contact with boundary */
    if (x <= obs[0].x1 ||
	x >= obs[0].x2 ||
	y <= obs[0].y1 ||
	y >= obs[0].y2 )
      {
	return 0;
      }
    return -1;                            /*  NO contact */
  }
  

void CanEat(Predator *rob,  Obstacle Obs[], Prey Food[], int step)
{
  int i;

  for(i = 0; i < nfood; i++)
    {
      if(Food[i].eaten == 0) 
	{
	  if (distance(rob->x[0], rob->y[0], 
		       (double) Food[i].x,(double) Food[i].y) 
	      <= FoodLength * 1.0)
	    {
	      rob->ate++;
	      rob->battery = FULLBAT;
	      Food[i].eaten = 1;	/* be eaten */
	      fprintf(stdout, "F %i at (%i, %i) eaten\n", i, Food[i].x, 
		      Food[i].y); 
	      Food[i].dead = 0;
	    } 
	  /**	  else 
	    { 
	      Eaten = 0; 
	    }
	    ********/
	}
     else
       {
	 Food[i].dead++; 
	 if (Food[i].dead >= DEADTIME) 
	   { 
	     Food[i].dead = 0; 
	     Food[i].eaten = 0; 
	     Food[i].alive++; 
	   } 
       }
      
    }
} /* end CanEat() */

