#include "const.h"
#include "type.h"
#include <unistd.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

void setsock(char *, int);
void setservsock(int, int);
void simulate(int, int, int, int);
void cleanup(void);
void getObstacles(char *fname);
void getPrey(char *fname);
void getPredator(char *fname);
void SendObsInfo(Obstacle obs[]);
void SendPreyInfo(Prey Food[]);
void SendNbots(int nbots);
void GetMessage(char *s);

char *controller[MAXBOTS];
char obsfile[1024] = "obs.dat";
char preyfile[1024] = "food.dat";
char predfile[1024] = "rob.dat";
char trainDataFile[1024];
double SoundRange = 80.0;
int FoodLength = 5;
int steps = 50;
int DEADTIME = 40;



extern int LM, RM;
extern int controlport, dsock, nbots, nfood, nobs;
extern Obstacle Obs[MAXOBS];
extern Prey Food[MAXFOOD];
extern Predator Robs[MAXBOTS];

int main(int argc, char * argv[])
{
  char c;
  extern char *optarg;
  char hostname[1024];
  int portnum;
  int i = 0;
  int display, extcontrol, ncontrols;
  time_t t;

  srandom(time( &t));


  extcontrol = 0;
  display = 1;
  controlport = CONPORT;

  strcpy(hostname, DFLTHOST);
  fprintf(stderr, "Display host %s\n", hostname);
  portnum = DPORT;
  strcpy(trainDataFile, "test.dat");

  while ((c = getopt(argc, argv, "h:c:p:f:o:r:d:s:D:t:T:")) != EOF) {
    switch(c)
      {
      case 'T': /* training file name */
	strcpy(trainDataFile, optarg);
	break;
      case 'D': /* hostname for displayer */
	display = atoi(optarg);
	break;
      case 't': /* hostname for displayer */
	DEADTIME = atoi(optarg);
	break;
      case 'h': /* hostname for displayer */
	display = 1;
	strcpy(hostname, optarg);
	break;
      case 'o': /* obstacle location file name */
	strcpy(obsfile, optarg);
	break;
      case 'f': /* prey location file name */
	strcpy(preyfile, optarg);
	break;
      case 'r': /* robot file name for start location */
	strcpy(predfile, optarg);
	break;
      case 'p': /* hostname for displayer */
	display = 1;
	portnum = atoi(optarg);
	break;
      case 's': /* hostname for displayer */
	steps = atoi(optarg);
	break;
      case 'd': /* hostname for displayer */
	SoundRange = atoi(optarg);
	break;
      case 'c': /* controller hostname */
	extcontrol = 1;
	controller[i] = (char *) malloc (strlen (optarg));
	strcpy(controller[i], optarg);
	i++;
	break;
      default: 
	perror("Incorrect options");
      }
  }
  
  getObstacles(obsfile);
  getPrey(preyfile);
  getPredator(predfile);
  ncontrols = nbots;

  fprintf(stderr, "Got environment data nbots = %i\n", ncontrols);

  if(display) {
    setsock(hostname, portnum);
    SendObsInfo(Obs);
    SendPreyInfo(Food);
    SendNbots(nbots);
  }
  

  if (extcontrol)
    setservsock(controlport, ncontrols);

  fprintf(stderr, "Sent environment data\n d = %i, con = %i\n",
	  display, extcontrol);

  if (display){
    GetMessage("(Start)");
  }
  simulate(display, extcontrol, ncontrols, steps);

  if(display)
    cleanup();

  return 0;
}

void cleanup(void)
{
  close(dsock);
}

