typedef struct  {
  int x1; 
  int y1;
  int x2;
  int y2; /* coords lower left and upper right corners of rectangle */
  int x;
  int y;
  int width;
  int height; /*coords lower left and height and width */
  int which; /* obstacle id */
} Obstacle;

typedef struct {
  int x; /* food coords */
  int y;
  int xmove[MAXSTEP]; /* not used, useful if prey moves */
  int ymove[MAXSTEP];
  int eaten; /* has it been eaten? 1 = eaten 0 = not eaten*/
  int dead;
  int alive;
}Prey;

typedef struct {
  int id;
  int ate; /* how many prey did this bot devour */
  int touch; /* how many times did the bot touch something, with sensors*/
  int hit; /* how many times did the bot's body hit something */
  double dist; /* how far did this bot travel */
  /* the variables above help determine how good your robot is*/
  int crash;

  double x[NSENSORS]; /* locations of body and sensors  */
  double y[NSENSORS];
  double status[NSENSORS]; /* status of body and sensors
			      1 = hit
			      0 = free */
  double deg; /* initial robot heading */
  double xmove[MAXSTEP]; /* path coords */
  double ymove[MAXSTEP];
  int motor[NMOTORBITS]; /* motor commands in binary */
  double NewAngle; /* new heading */
  double NewStep; /* new move distance */

  int currentstep; /* which step of the simulation */
  float battery;
} Predator;

typedef struct {
  int area[300][300];
} Area;
