#include "const.h"
#include "type.h"
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "control.h"

int flip(double prob);
void sensorprint(Predator *p, char *s);
void fitnessprint(Predator *p, int nbots);

extern int EnvX, EnvY;
extern Area cover[MAXBOTS];

void fitnessprint(Predator *p, int nbots)
{
  int i, j, k, sum[MAXBOTS];

  for(i = 0; i < MAXBOTS; i++)
    sum[i] = 0;

  for (k = 0; k < nbots; k++)
    {
      for(i = 0; i < EnvX; i++)
	{
	  for(j = 0; j < EnvY; j++)
	    {
	      sum[k] += cover[k].area[i][j];
	    }
	}
    }

  for(i = 0; i < nbots;i++)
    {
      fprintf(stdout, 
	      "Rob %i ate %i touched %i hit %i, travelled %f, and covered %i\n", 
	      i, p[i].ate, p[i].touch, p[i].hit, p[i].dist, sum[i]); 
    }
	      

}



int flip(double prob) 
{ 
  if (random()%1000 <= (int) prob*1000.0 )  
    return 1; 
  else  
    return 0; 
} 

void sensorprint(Predator *p, char *s)
{
  int j;
  printf("%s R %i ", s, p->id);
  for(j = 0; j < NSENSORS; j++)
    {
      printf("%f ", p->status[j]);
    }
  printf("\n");
}

void PrintBatteryStates(Predator *p, int n)
{
  int i;
  for (i = 0; i < n; i++) {
    fprintf(stdout, "Rob[%2d] %f\n", i, p[i].battery);
  }
}

void sensorfprintUser(FILE *fp, Predator *p, char *s)
{
  /*  fprintf(fp, "%s R %i ", s, p->id); */
  
  /* normalize sound */
  fprintf(fp, "\n \t %f \n", p->status[5] - p->status[6]);

  fprintf(fp, "%3.0f %3.0f %3.0f\n", p->status[1], p->status[0], p->status[3]);
  fprintf(fp, "  %3.0f %3.0f\n", p->status[2], p->status[4]);

  fprintf(fp, "\t%f\n", p->battery);
  fprintf(fp, "-------------------------------------------------\n");
  

}

void sensorfprint(FILE *fp, Predator *p, char *s)
{
  /*  fprintf(fp, "%s R %i ", s, p->id); */
  
  /* normalize sound */
  fprintf(fp, "%5.3f %5.3f ", p->status[5],  p->status[6]);

  fprintf(fp, "\t%1.0f %1.0f %1.0f ", 
	  p->status[0], p->status[1], p->status[2]);
  fprintf(fp, "%1.0f %1.0f ", p->status[3], p->status[4]);

  fprintf(fp, " %4.0f ", p->battery);

  /* print actuator values next*/

  /*  fprintf(fp, "-------------------------------------------------\n");*/
  

}

void actuatorfprint(FILE *fp, Predator *p, char*s)
{

  int i;
    fprintf(fp, "\t");
  for(i = 0; i < NMOTORBITS; i++){
    fprintf(fp, "%1d ", p->motor[i]);
  }

  fprintf(fp, "\n");
}


void FPrintBatteryStates(FILE *fp, Predator *p, int n)
{
  int i;
  for (i = 0; i < n; i++) {
    fprintf(fp, "Rob[%2d] %f\n", i, p[i].battery);
  }
}

